#include <iostream>
#include <vector>
#include <string>
#include <algorithm>
#include <set>
#include <map>

using namespace std;

typedef long long ll;


set<ll> cache_full[20]; 
bool computed[20];


set<ll> get_all_for_length(int len) {
    if (len == 0) return {1};
    if (computed[len]) return cache_full[len];
    
    set<ll> prev = get_all_for_length(len - 1);
    set<ll> current;
    current.insert(0); 
    for (ll p : prev) {
        for (int d = 1; d <= 9; ++d) {
            current.insert(p * d);
        }
    }
    computed[len] = true;
    return cache_full[len] = current;
}


int solve_query() {
    string s;
    if (!(cin >> s)) return -1;
    int n_len = s.size();
    
    set<ll> ukupno;
    
   
    for (int i = 1; i < n_len; ++i) {
        set<ll> s_len = get_all_for_length(i);
        ukupno.insert(s_len.begin(), s_len.end());
    }
    
   
    ll current_prefix_prod = 1;
    for (int i = 0; i < n_len; ++i) {
        int digit = s[i] - '0';
        int start = (i == 0) ? 1 : 0; 
        
        for (int d = start; d < digit; ++d) {
            ll temp_prod = current_prefix_prod * d;
            int preostalo = n_len - 1 - i;
            
            if (temp_prod == 0) {
                ukupno.insert(0);
            } else {
                set<ll> sufiksi = get_all_for_length(preostalo);
                for (ll sp : sufiksi) ukupno.insert(temp_prod * sp);
            }
        }
        current_prefix_prod *= digit;
        if (current_prefix_prod == 0) {
            ukupno.insert(0);
            break;
        }
    }
    
    ukupno.insert(current_prefix_prod);
    
    return ukupno.size();
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int T;
    if (!(cin >> T)) return 0;
    while (T--) {
        int res = solve_query();
        cout << res << "\n";
    }
    return 0;
}